/*
 * Decompiled with CFR 0.152.
 */
package org.autoclickers.multiclicker;

import java.io.Serializable;
import java.util.Random;
import org.autoclickers.multiclicker.co;

public final class cd
implements Serializable {
    private double[] output;
    private double totalError = 1.0;
    private int inputNeuronCount;
    private int outputNeuronCount;
    private static final Random RANDOM = new Random(System.currentTimeMillis());
    private double[][] outputWeights;
    private static final int LEARN_METHOD = 1;
    private static final double LEARN_RATE = 0.5;
    private static final double QUIT_ERROR = 0.1;
    private static final int RETRIES = 10000;
    private static final double REDUCTION = 0.99;
    public boolean halt = false;
    public co train;

    public cd(int n2, int n3) {
        this.inputNeuronCount = n2;
        this.outputNeuronCount = n3;
        this.outputWeights = new double[this.outputNeuronCount][this.inputNeuronCount + 1];
        this.output = new double[this.outputNeuronCount];
    }

    public final void setTrainingSet(co co2) {
        this.train = co2;
    }

    public static void copyWeights(cd cd2, cd cd3) {
        for (int i2 = 0; i2 < cd3.outputWeights.length; ++i2) {
            System.arraycopy(cd3.outputWeights[i2], 0, cd2.outputWeights[i2], 0, cd3.outputWeights[i2].length);
        }
    }

    public final void clearWeights() {
        this.totalError = 1.0;
        for (int i2 = 0; i2 < this.outputWeights.length; ++i2) {
            for (int i3 = 0; i3 < this.outputWeights[0].length; ++i3) {
                this.outputWeights[i2][i3] = 0.0;
            }
        }
    }

    private void normalizeInput(double[] dArray, double[] dArray2, double[] dArray3) {
        double d2;
        double d3 = cd.vectorLength(dArray);
        if (d2 < 1.0E-30) {
            d3 = 1.0E-30;
        }
        dArray2[0] = 1.0 / Math.sqrt(d3);
        dArray3[0] = 0.0;
    }

    private void normalizeWeight(double[] dArray) {
        double d2;
        double d3 = cd.vectorLength(dArray);
        if (d2 < 1.0E-30) {
            d3 = 1.0E-30;
        }
        d3 = 1.0 / Math.sqrt(d3);
        int n2 = 0;
        while (n2 < this.inputNeuronCount) {
            int n3 = n2++;
            dArray[n3] = dArray[n3] * d3;
        }
        dArray[this.inputNeuronCount] = 0.0;
    }

    public final void trial(double[] dArray) {
        double[] dArray2 = new double[1];
        double[] dArray3 = new double[1];
        this.normalizeInput(dArray, dArray2, dArray3);
        for (int i2 = 0; i2 < this.outputNeuronCount; ++i2) {
            double[] dArray4 = this.outputWeights[i2];
            this.output[i2] = this.dotProduct(dArray, dArray4) * dArray2[0] + dArray3[0] * dArray4[this.inputNeuronCount];
            this.output[i2] = 0.5 * (this.output[i2] + 1.0);
            if (this.output[i2] > 1.0) {
                this.output[i2] = 1.0;
            }
            if (!(this.output[i2] < 0.0)) continue;
            this.output[i2] = 0.0;
        }
    }

    public final int winner(double[] dArray, double[] dArray2, double[] dArray3) {
        int n2 = 0;
        this.normalizeInput(dArray, dArray2, dArray3);
        double d2 = -1.0E30;
        for (int i2 = 0; i2 < this.outputNeuronCount; ++i2) {
            double[] dArray4 = this.outputWeights[i2];
            this.output[i2] = this.dotProduct(dArray, dArray4) * dArray2[0] + dArray3[0] * dArray4[this.inputNeuronCount];
            this.output[i2] = 0.5 * (this.output[i2] + 1.0);
            if (this.output[i2] > d2) {
                d2 = this.output[i2];
                n2 = i2;
            }
            if (this.output[i2] > 1.0) {
                this.output[i2] = 1.0;
            }
            if (!(this.output[i2] < 0.0)) continue;
            this.output[i2] = 0.0;
        }
        return n2;
    }

    private void evaluateErrors(double d2, int n2, int[] nArray, double[] dArray, double[][] dArray2, double[] dArray3) {
        int n3;
        double[] dArray4 = new double[1];
        double[] dArray5 = new double[1];
        for (n3 = 0; n3 < dArray2.length; ++n3) {
            for (int i2 = 0; i2 < dArray2[0].length; ++i2) {
                dArray2[n3][i2] = 0.0;
            }
        }
        for (n3 = 0; n3 < nArray.length; ++n3) {
            nArray[n3] = 0;
        }
        dArray[0] = 0.0;
        for (int i3 = 0; i3 < this.train.getTrainingSetCount(); ++i3) {
            double d3;
            int n4;
            double[] dArray6 = this.train.getInputSet(i3);
            int n5 = n4 = this.winner(dArray6, dArray4, dArray5);
            nArray[n5] = nArray[n5] + 1;
            double[] dArray7 = this.outputWeights[n4];
            double[] dArray8 = dArray2[n4];
            double d4 = 0.0;
            for (n3 = 0; n3 < this.inputNeuronCount; ++n3) {
                d3 = dArray6[n3] * dArray4[0] - dArray7[n3];
                d4 += d3 * d3;
                if (n2 != 0) {
                    int n6 = n3;
                    dArray8[n6] = dArray8[n6] + d3;
                    continue;
                }
                dArray3[n3] = d2 * dArray6[n3] * dArray4[0] + dArray7[n3];
            }
            d3 = dArray5[0] - dArray7[this.inputNeuronCount];
            d4 += d3 * d3;
            if (n2 != 0) {
                int n7 = this.inputNeuronCount;
                dArray8[n7] = dArray8[n7] + d3;
            } else {
                dArray3[this.inputNeuronCount] = d2 * dArray5[0] + dArray7[this.inputNeuronCount];
            }
            if (d4 > dArray[0]) {
                dArray[0] = d4;
            }
            if (n2 != 0) continue;
            this.normalizeWeight(dArray3);
            for (n3 = 0; n3 <= this.inputNeuronCount; ++n3) {
                int n8 = n3;
                dArray8[n8] = dArray8[n8] + (dArray3[n3] - dArray7[n3]);
            }
        }
        dArray[0] = Math.sqrt(dArray[0]);
    }

    private void adjustWeights(double d2, int n2, int[] nArray, double[] dArray, double[][] dArray2) {
        dArray[0] = 0.0;
        for (int i2 = 0; i2 < this.outputNeuronCount; ++i2) {
            if (nArray[i2] == 0) continue;
            double[] dArray3 = this.outputWeights[i2];
            double[] dArray4 = dArray2[i2];
            double d3 = 1.0 / (double)nArray[i2];
            if (n2 != 0) {
                d3 *= d2;
            }
            double d4 = 0.0;
            int n3 = 0;
            while (n3 <= this.inputNeuronCount) {
                double d5 = d3 * dArray4[n3];
                int n4 = n3++;
                dArray3[n4] = dArray3[n4] + d5;
                d4 += d5 * d5;
            }
            if (!(d4 > dArray[0])) continue;
            dArray[0] = d4;
        }
        dArray[0] = Math.sqrt(dArray[0]) / d2;
    }

    private void forceWin(int[] objectArray) {
        int n2;
        int n3 = 0;
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        double d2 = 1.0E30;
        for (n2 = 0; n2 < this.train.getTrainingSetCount(); ++n2) {
            double[] dArray3 = this.train.getInputSet(n2);
            int n4 = this.winner(dArray3, dArray, dArray2);
            if (!(this.output[n4] < d2)) continue;
            d2 = this.output[n4];
            n3 = n2;
        }
        double[] dArray4 = this.train.getInputSet(n3);
        this.winner(dArray4, dArray, dArray2);
        d2 = -1.0E30;
        n2 = this.outputNeuronCount;
        while (n2-- > 0) {
            if (objectArray[n2] != 0 || !(this.output[n2] > d2)) continue;
            d2 = this.output[n2];
            n3 = n2;
        }
        objectArray = this.outputWeights[n3];
        System.arraycopy(dArray4, 0, objectArray, 0, dArray4.length);
        objectArray[this.inputNeuronCount] = (int)(dArray2[0] / dArray[0]);
        this.normalizeWeight((double[])objectArray);
    }

    public final void learn() {
        int n2;
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        this.totalError = 1.0;
        for (n2 = 0; n2 < this.train.getTrainingSetCount(); ++n2) {
            double[] dArray3;
            double[] dArray4 = this.train.getInputSet(n2);
            if (!(cd.vectorLength(dArray3) < 1.0E-30)) continue;
            throw new RuntimeException("Multiplicative normalization has null training case");
        }
        cd cd2 = new cd(this.inputNeuronCount, this.outputNeuronCount);
        int[] nArray = new int[this.outputNeuronCount];
        double[][] dArray5 = new double[this.outputNeuronCount][this.inputNeuronCount + 1];
        double d2 = 0.5;
        this.initialize();
        double d3 = 1.0E30;
        int n3 = 0;
        while (true) {
            this.evaluateErrors(d2, 1, nArray, dArray, dArray5, null);
            this.totalError = dArray[0];
            if (this.totalError < d3) {
                d3 = this.totalError;
                cd.copyWeights(cd2, this);
            }
            int n4 = 0;
            for (n2 = 0; n2 < nArray.length; ++n2) {
                if (nArray[n2] == 0) continue;
                ++n4;
            }
            if (dArray[0] < 0.1) break;
            if (n4 < this.outputNeuronCount && n4 < this.train.getTrainingSetCount()) {
                this.forceWin(nArray);
                continue;
            }
            this.adjustWeights(d2, 1, nArray, dArray2, dArray5);
            Thread.yield();
            if (dArray2[0] < 1.0E-5) {
                if (++n3 > 10000) break;
                this.initialize();
                d2 = 0.5;
                continue;
            }
            if (!(d2 > 0.01)) continue;
            d2 *= 0.99;
        }
        cd.copyWeights(this, cd2);
        for (n2 = 0; n2 < this.outputNeuronCount; ++n2) {
            this.normalizeWeight(this.outputWeights[n2]);
        }
        this.halt = true;
    }

    private void initialize() {
        this.clearWeights();
        this.randomizeWeights(this.outputWeights);
        for (int i2 = 0; i2 < this.outputNeuronCount; ++i2) {
            double[] dArray = this.outputWeights[i2];
            this.normalizeWeight(dArray);
        }
    }

    private static double vectorLength(double[] dArray) {
        double d2 = 0.0;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            d2 += dArray[i2] * dArray[i2];
        }
        return d2;
    }

    private double dotProduct(double[] dArray, double[] dArray2) {
        double d2 = 0.0;
        int n2 = dArray.length;
        int n3 = 0;
        while (n2-- > 0) {
            d2 += dArray[n3] * dArray2[n3];
            ++n3;
        }
        return d2;
    }

    private void randomizeWeights(double[][] dArray) {
        int n2 = (int)(3.464101615 / (2.0 * Math.random()));
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            for (int i3 = 0; i3 < dArray[0].length; ++i3) {
                double d2 = (double)RANDOM.nextInt(Integer.MAX_VALUE) + (double)RANDOM.nextInt(Integer.MAX_VALUE) - (double)RANDOM.nextInt(Integer.MAX_VALUE) - (double)RANDOM.nextInt(Integer.MAX_VALUE);
                dArray[i2][i3] = (double)n2 * d2;
            }
        }
    }
}

