Attribute VB_Name = "modQuickCase"
Option Explicit

'32-Bit Windows API Functions
Public Declare Function FindWindow Lib "user32" Alias "FindWindowA" (ByVal lpClassName As String, ByVal lpWindowName As String) As Long
Public Declare Function FindWindowEx Lib "user32" Alias "FindWindowExA" (ByVal hWnd1 As Long, ByVal hWnd2 As Long, ByVal lpsz1 As String, ByVal lpsz2 As String) As Long
Public Declare Function GetWindowText Lib "user32" Alias "GetWindowTextA" (ByVal hwnd As Long, ByVal lpString As String, ByVal cch As Long) As Long
Public Declare Function IsWindowVisible Lib "user32" (ByVal hwnd As Long) As Long
Public Declare Function PostMessage Lib "user32" Alias "PostMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Public Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, lParam As Any) As Long
Public Declare Function SetWindowPos Lib "user32" (ByVal hwnd As Long, ByVal hWndInsertAfter As Long, ByVal X As Long, ByVal Y As Long, ByVal cx As Long, ByVal cy As Long, ByVal wFlags As Long) As Long

'Registry Functions for my sloppy registry usage.
Public Declare Function RegCloseKey Lib "advapi32.dll" (ByVal hKey As Long) As Long
Public Declare Function RegCreateKey Lib "advapi32.dll" Alias "RegCreateKeyA" (ByVal hKey As Long, ByVal lpSubKey As String, phkResult As Long) As Long
Public Declare Function RegQueryValue Lib "advapi32.dll" Alias "RegQueryValueA" (ByVal hKey As Long, ByVal lpSubKey As String, ByVal lpValue As String, lpcbValue As Long) As Long
Public Declare Function RegQueryValueEx Lib "advapi32.dll" Alias "RegQueryValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal lpReserved As Long, lpType As Long, lpData As Any, lpcbData As Long) As Long
Public Declare Function RegOpenKey Lib "advapi32.dll" Alias "RegOpenKeyA" (ByVal hKey As Long, ByVal lpSubKey As String, phkResult As Long) As Long
Public Declare Function RegOpenKeyEx Lib "advapi32.dll" Alias "RegOpenKeyExA" (ByVal hKey As Long, ByVal lpSubKey As String, ByVal ulOptions As Long, ByVal samDesired As Long, phkResult As Long) As Long
Public Declare Function RegSetValue Lib "advapi32.dll" Alias "RegSetValueA" (ByVal hKey As Long, ByVal lpSubKey As String, ByVal dwType As Long, ByVal lpData As String, ByVal cbData As Long) As Long
Public Declare Function RegSetValueEx Lib "advapi32.dll" Alias "RegSetValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal Reserved As Long, ByVal dwType As Long, lpData As Any, ByVal cbData As Long) As Long

'Cobstants
Public Const REG_SZ = 1
Public Const ERROR_SUCCESS = 0&
Public Const HKEY_CURRENT_USER = &H80000001
Public Const READ_CONTROL = &H20000
Public Const KEY_SET_VALUE = &H2&
Public Const KEY_CREATE_SUB_KEY = &H4&
Public Const STANDARD_RIGHTS_WRITE = READ_CONTROL
Public Const KEY_WRITE = STANDARD_RIGHTS_WRITE Or KEY_SET_VALUE Or KEY_CREATE_SUB_KEY
Public Const HWND_TOPMOST = -1
Public Const WM_USER = &H400
Public Const WM_CLOSE = &H10
Public Const WM_CHAR = &H102
Public Const WM_DESTROY = &H2
Public Const WM_HELP = &H53
Public Const WM_KEYDOWN = &H100
Public Const WM_KEYUP = &H101
Public Const WM_LBUTTONDOWN = &H201
Public Const WM_LBUTTONUP = &H202
Public Const WM_SETFOCUS = &H7
Public Const WM_SETTEXT = &HC
Public Const SWP_NOACTIVATE = &H10
Public Const SWP_NOMOVE = &H2
Public Const SWP_NOSIZE = &H1
Public Const VK_RETURN = &HD
Public Const VK_SPACE = &H20

'Other variables
Public strUser As String, intBoots As Integer
Public bolChatsendLoad As Boolean, bolChatsendUnload As Boolean
Public bolChatsendCase As Boolean

Public Function AOL_ChatRoomName() As String

    AOL_ChatRoomName = Window_Text(AOL_FindChat)

End Function
Public Function AOL_FindMsgBox() As Long

    AOL_FindMsgBox = FindWindow("#32770", "America Online")

End Function




Public Sub Picture_Inset(picPicture As PictureBox)

    With picPicture
        picPicture.Line (0, 0)-(.Width, .Height), vbButtonShadow, B
        picPicture.Line (-15, -15)-(.ScaleWidth - 15, .ScaleHeight - 15), vb3DHighlight, B
    End With

End Sub

Public Sub Timeout(lngPause As Long)

    Dim lngTimer As Long
    
    lngTimer = Timer
    
    Do Until Timer - lngTimer >= lngPause
        DoEvents
    Loop

End Sub


Public Sub AOL_ChatSend(strText As String)

    Dim lngRICHCNTL As Long
    
    lngRICHCNTL = FindWindowEx(AOL_FindChat, 0&, "RICHCNTL", vbNullString)
    
    SendMessage lngRICHCNTL, WM_SETTEXT, 0&, ByVal vbNullChar
    SendMessage lngRICHCNTL, WM_SETTEXT, 0&, ByVal strText
    SendMessage lngRICHCNTL, WM_CHAR, VK_RETURN, 0&

End Sub

Public Function AOL_FindChat() As Long

    Dim lngChildWnd As Long, lngRICHCNTL As Long
    Dim lngRICHCNTLREADONLY As Long, lngListbox As Long
    Dim lngIcon As Long, lngStatic As Long
    
    Do: DoEvents
        lngChildWnd = FindWindowEx(AOL_FindMDIClient, lngChildWnd, "AOL Child", vbNullString)
        lngRICHCNTL = FindWindowEx(lngChildWnd, 0&, "RICHCNTL", vbNullString)
        lngRICHCNTLREADONLY = FindWindowEx(lngChildWnd, 0&, "RICHCNTLREADONLY", vbNullString)
        lngListbox = FindWindowEx(lngChildWnd, 0&, "_AOL_Listbox", vbNullString)
        lngIcon = FindWindowEx(lngChildWnd, 0&, "_AOL_Icon", vbNullString)
        lngStatic = FindWindowEx(lngChildWnd, 0&, "_AOL_Static", vbNullString)
        If lngChildWnd <> 0& And lngRICHCNTL <> 0& And lngRICHCNTLREADONLY <> 0& _
            And lngListbox <> 0& And lngIcon <> 0& And lngStatic <> 0& Then GoTo gtFound:
    Loop Until lngChildWnd = 0&: Exit Function

gtFound:
    AOL_FindChat = lngChildWnd

End Function
Public Function AOL_FindFrame25() As Long

    AOL_FindFrame25 = FindWindow("AOL Frame25", vbNullString)

End Function

Public Function AOL_FindMDIClient() As Long

    AOL_FindMDIClient = FindWindowEx(AOL_FindFrame25, 0&, "MDIClient" _
                        , vbNullString)

End Function


Public Function AOL_FindToolbar() As Long

    Dim lngToolbarWin As Long

    lngToolbarWin = FindWindowEx(AOL_FindFrame25, 0&, "AOL Toolbar", vbNullString)
                     
    AOL_FindToolbar = FindWindowEx(lngToolbarWin, 0&, "_AOL_Toolbar", vbNullString)
    

End Function

Function AOL_GetScreenName() As String

    Dim lngAOLWelcome As Long, strBuffer As String * 255, strTemp As String
    
    lngAOLWelcome = 0
    
    Do: DoEvents
        lngAOLWelcome = FindWindowEx(AOL_FindMDIClient, lngAOLWelcome, "AOL Child", vbNullString)
        GetWindowText lngAOLWelcome, strBuffer, Len(strBuffer)
    Loop Until (InStr(strBuffer, "Welcome, ")) <> 0 Or lngAOLWelcome = 0&
    
    If lngAOLWelcome = 0& Then AOL_GetScreenName = "": Exit Function
    
    strTemp = Left(strBuffer, InStr(strBuffer, vbNullChar) - 1)
    strTemp = Mid(strTemp, Len("Welcome, ") + 1)
    strTemp = Mid(strTemp, 1, Len(strTemp) - 1)
    
    AOL_GetScreenName = Trim(Replace(strTemp, " ", ""))

End Function
Public Sub AOL_Keyword(strKeyword As String)

    Dim lngToolbar As Long, lngToolbar2 As Long
    Dim lngEdit As Long, intStep As Integer
    
    
    lngToolbar = FindWindowEx(AOL_FindFrame25, 0&, "AOL Toolbar", vbNullString)
    lngToolbar2 = FindWindowEx(lngToolbar, 0&, "_AOL_Toolbar", vbNullString)
    lngEdit = FindWindowEx(lngToolbar2, 0&, "_AOL_Edit", vbNullString)
    
    SendMessage lngEdit, WM_LBUTTONUP, 0&, 0&
    SendMessage lngEdit, WM_LBUTTONDOWN, 0&, 0&
    
    SendMessage lngEdit, WM_SETTEXT, 0&, ByVal strKeyword
    SendMessage lngEdit, WM_CHAR, VK_SPACE, 0&
    SendMessage lngEdit, WM_CHAR, VK_RETURN, 0&

End Sub
Public Sub AOL_ToolbarClick(intTool As Integer)

    Dim lngAOLIcon As Long, intStep As Integer
    
    
    For intStep = 0 To intTool
        lngAOLIcon = FindWindowEx(AOL_FindToolbar, lngAOLIcon, "_AOL_Icon", vbNullString)
    Next
    
    Window_Click lngAOLIcon

End Sub
Public Sub AOL_ToolbarRunMenu(intMenu As Integer, strKey As String)

    Dim lngMenuHwnd As Long, lngKeyChar As Long
    
    lngKeyChar = Asc(strKey)

    AOL_ToolbarClick intMenu
    
    Do: DoEvents
        lngMenuHwnd = FindWindow("#32768", vbNullString)
    Loop Until IsWindowVisible(lngMenuHwnd)
    
    SendMessage lngMenuHwnd, WM_CHAR, lngKeyChar, 0&

End Sub

Public Sub Form_OnTop(frmForm As Form)

    SetWindowPos frmForm.hwnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOACTIVATE Or SWP_NOMOVE Or SWP_NOSIZE

End Sub

Public Function Registry_Read(strKey As String, strDefault As String) As String

    On Error Resume Next
    
    Dim lngReturn As Long, lnghKey As Long, strBuffer As String
    Dim lngBuffer As Long
    
    strBuffer = Space(255)
    lngBuffer = Len(strBuffer)
    
    lngReturn = RegOpenKeyEx(HKEY_CURRENT_USER, "Software\Quick Case", 0, REG_SZ, lnghKey)
    
    If lngReturn = ERROR_SUCCESS Then
        lngReturn = RegQueryValueEx(lnghKey, strKey, 0&, 0&, ByVal strBuffer, lngBuffer)
    Else
        strBuffer = strDefault
    End If
    
    lngReturn = RegCloseKey(lnghKey)
    
    Registry_Read = Trim(Left(strBuffer, lngBuffer - 1))

End Function


Public Sub Registry_Write(strKey As String, strValue As String)

    Dim lngReturn As Long, lnghKey As Long
    
gtKeyWrite:
    lngReturn = RegOpenKeyEx(HKEY_CURRENT_USER, "Software\Quick Case", 0, KEY_WRITE, lnghKey)
    
    If lngReturn = ERROR_SUCCESS Then
        lngReturn = RegSetValueEx(lnghKey, strKey, 0, REG_SZ, ByVal strValue, Len(strValue))
    Else
        RegCreateKey HKEY_CURRENT_USER, "Software\Quick Case", 0&
        GoTo gtKeyWrite
    End If
    
    lngReturn = RegCloseKey(lnghKey)

End Sub

Public Function Text_Hacker(strText As String) As String

    strText = UCase(strText)
    strText = Replace(strText, "A", "a")
    strText = Replace(strText, "E", "e")
    strText = Replace(strText, "I", "i")
    strText = Replace(strText, "O", "o")
    strText = Replace(strText, "U", "u")
    
    Text_Hacker = strText

End Function

Public Sub Window_Click(lngHwnd As Long)

    PostMessage lngHwnd, WM_LBUTTONDOWN, 0&, 0&
    PostMessage lngHwnd, WM_KEYUP, VK_SPACE, 0&
    PostMessage lngHwnd, WM_LBUTTONUP, 0&, 0&

End Sub


Public Function Window_Text(lngWindow As Long) As String

    Dim strBuffer As String * 255
    
    GetWindowText lngWindow, strBuffer, Len(strBuffer)
    
    strBuffer = Left(strBuffer, InStr(strBuffer, vbNullChar) - 1)
    
    Window_Text = strBuffer

End Function


